var isMobile = (/iphone|ipad|ipod|android|blackberry|mini|windows\sce|palm/i.test(navigator.userAgent.toLowerCase()));

var ajax = function(url, type, dataType, contentType, data, async, showLoader, success, fail) {
	$.ajax({
    	url: url, 
    	type: type,
    	dataType: dataType === null ? 'html' : dataType,
    	contentType: contentType === null ? 'text/html' : contentType,
    	data: data,
    	async: async === null ? true : async,
    	cache: false,
    	crossDomain: true,
    	beforeSend: function() {
    		if (showLoader) { 
    			$('.loader').addClass('show');
    		}
    	},
    	success: function(response) {
    		success(response);
    		$('.loader').removeClass('show');
    	},
    	error: function(error) {
    		fail(error.responseText);
    		$('.loader').removeClass('show');
    	}
	});
};

var _login = {
	loginBhe: function () {
	    $('body').on('click', '.btn-login', function() {
			var $this = $(this);
			if ( $this.data('goto-url')) {
				sessionStorage.setItem('current-page',  $this.data('goto-url'));
				if ($this.data('click-fai-domanda')==true) {
					sessionStorage.setItem('click-fai-domanda', "true");
				}
			} else {
				sessionStorage.setItem('current-page', window.location.href);
				var btnFiltroTipoBando = $('.bottoni-target > .btn-active');
				if (btnFiltroTipoBando.length==1 && btnFiltroTipoBando.data("filter")) {
					sessionStorage.setItem('bandi-filter',btnFiltroTipoBando.data("filter"));
				}
				var btnCatBandoPage = $('.catalogo_bandi > .row > div > nav > .pagination > .page-item > .page-num[aria-current="page"]');
				if (btnCatBandoPage && btnCatBandoPage.length==1) {
					sessionStorage.setItem('cat-bandi-page',btnCatBandoPage.data("page-num"));
				}
			}
			if ( $this.data('click-favorite')) {
				sessionStorage.setItem('click-favorite',  $this.data('click-favorite'));
			}
			
			
	    });
	},
	init: function () {
		this.loginBhe();
	}
};

var _logout = {
	logoutBhe: function () {
	    $('body').on('click', '.btn-logout', function() {
	    	sessionStorage.removeItem("current-page");
			sessionStorage.removeItem('click-fai-domanda');
			sessionStorage.removeItem('bandi-filter');
	    });
	},
	init: function () {
		this.logoutBhe();
	}
};

var _calcNavOffsetTop = {
    menuBehaviors: function () {
        if (($(window).outerWidth() < 992)) {
            var navOffsetTop = ($(".it-header-slim-wrapper").outerHeight() + $(".it-nav-wrapper").outerHeight());
            $("header").addClass("sticky-header");
            $("main").css("margin-top", navOffsetTop);
            $(".navbar-collapsable").css("top", navOffsetTop);
            $(".navbar-collapsable .overlay").css("top", $(".it-header-slim-wrapper").outerHeight());
        } else {
            $("header").removeClass("sticky-header");
            $("main").removeAttr('style');
            $(".navbar-collapsable").removeAttr('style');
            $(".navbar-collapsable .overlay").removeAttr('style');
        }
    },
    onLoad: function () {
        if (($(window).outerWidth() < 992)) {
            $(".it-header-wrapper .it-header-navbar-wrapper .custom-navbar-toggler").click(function () {
            	$(this).children().toggleClass("d-none");
            });
            $(".navbar-collapsable .overlay").click(function () {
                $(".it-header-wrapper .it-header-navbar-wrapper .custom-navbar-toggler").children().toggleClass("d-none");
            });
        }
    },
    init: function () {
        if($('.it-header-wrapper').length > 0){
            this.onLoad();
            this.menuBehaviors();
            $( window ).resize(function() {
            	_calcNavOffsetTop.menuBehaviors();
            });
        }
    }
};

var $wrapperData = $('.contDataOra');

var _get_date_time = {
    time: function () {
        var intervalTime = $wrapperData.data('interval-time');
        this.getTime();
        setInterval(this.getTime, intervalTime);
    },
    getTime: function () {
    	$.ajax({
			dataType: "html",
			crossDomain: true,
            url: $wrapperData.data('url'),
			data: '',
			type: "GET",
			cache: false,
			processData: true,
			contentType: 'application/json',
			success: function(data) {
				$wrapperData.html(data);
			},
			error: function(xhr) {
				console.log(xhr.responseText);
			}
		});
    },
    init: function () {
        if($wrapperData.length > 0){
            this.time();
        }
    }
};

var _popoverLogin = {
    popoverBehaviors: function () {
    	$('.tendina-login .btn-primary').find('.popover-profile[data-toggle="popover"]').popover();
        $(".btn-primary").parent().on('shown.bs.dropdown', function () {
        	$( ".link-list-wrapper .popover-profile" ).each(function() {
        		if($(this).get(0).offsetWidth < $(this).get(0).scrollWidth){
        			$(this).popover();
        		}
        	});
        });
    },
    init: function () {
    	if($('.tendina-login .btn-primary').length > 0 && !isMobile){
            this.popoverBehaviors();
        }
    }
};

var _openFooterModal = {
	openFooterModalBhe: function () {
	    $('.open-modal-footer').on('click', function(e) {
	    	e.preventDefault();
	    	_openFooterModal.show($(this).data('content'));
	    });
	},
	show: function (content) {
	    	
	    var url = window.__CONTEXT_PATH__ + '/api/openFooterModal?content=' + content;
		$.get(url, function(fragment) {
			if(fragment.indexOf('error-page') !== -1){
				_openAlert.show(window.__ERROR_MSG__,window.__ERROR_ICON__,window.__ERROR_COLOR_ICON__);
			} else {
				$("#modalFooter").replaceWith(fragment);
				$("#modalFooter").modal('show');
			}
		}).fail(function() {
			_openAlert.show(window.__ERROR_MSG__,window.__ERROR_ICON__,window.__ERROR_COLOR_ICON__);
		});
			
	},
	init: function () {
	    if($('.open-modal-footer').length > 0){
	       	this.openFooterModalBhe();
	    }
	}
};

/*
Per creare un nuovo popup: 
- Aggiungere la classe 'open-common-modal' all'elemento del DOM interessato
- (obbligatorio) Aggiungere allo stesso l'attributo 'data-content' con valore il nome del fragment interessato
- Inserire nel fragment 'popup-content.html' il contenuto della popup con nome uguale a quanto definito nell'attributo 'data-content'
- (facoltativo) Ulteriori attributi definiti come 'data-*' da passare al fragment interessato (prestare attenzione alla conversione camel case)
- (facoltativo) Definire tramite attributo 'data-checkbox' eventuali campi della suddetta tipologia mappati lato Java
- (facoltativo) Definire tramite attributo 'data-select' eventuali campi della suddetta tipologia mappati lato Java
- (facoltativo) Definire tramite attributo 'data-radio' eventuali campi della suddetta tipologia mappati lato Java
*/
var _openCommonModal = {
	openCommonModalBhe: function () {
	    $('body').on('click', '.open-common-modal', function(e) {
	    	e.preventDefault();
	    	_openCommonModal.show($(this).data());
	    	
	    	if(isMobile && $(this).hasClass('nav-link')){
	    		$(".it-header-wrapper .it-header-navbar-wrapper .custom-navbar-toggler").children().toggleClass("d-none");
	    	}
	    });
	},
	show: function (data) {
		if($('#modalPopup').hasClass('show')) {
			_openCommonModal.hide(function() {
				_openCommonModal.replaceAndShow(data);
			});
		} else {
			_openCommonModal.replaceAndShow(data);
		}
	},
	replaceAndShow: function(data) {
		$.get(window.__CONTEXT_PATH__ + '/api/openCommonModal', data, function(fragment) {
			if(fragment.indexOf('error-page') !== -1){
				_openAlert.show(window.__ERROR_MSG__,window.__ERROR_ICON__,window.__ERROR_COLOR_ICON__);
			} else {
				$("#modalPopup").replaceWith(fragment);
				var _btnLogin = $("#modalPopup").find(".btn-login");
				if (_btnLogin) {
					var goToUrl = data.gotoUrl;
					if (goToUrl ) {
						_btnLogin.attr('data-goto-url', goToUrl);
					}
				}
				$("#modalPopup").modal('show');
			}
		}).fail(function() {
			_openAlert.show(window.__ERROR_MSG__,window.__ERROR_ICON__,window.__ERROR_COLOR_ICON__);
		});
	},
	hide: function (callback) {
		$('#modalPopup').on('hidden.bs.modal', function (e) {
			if(callback != null) {
				callback();
			}
		});
		$("#modalPopup").modal('hide');
	},
	init: function () {
		this.openCommonModalBhe();
	}
};

var _changeProfile = {
	changeProfileBhe: function () {
	    $('body').on('click', '.change-profile', function() {
	    	$('.loader').addClass('show');
	    });
	},
	init: function () {
		this.changeProfileBhe();
	}
};

var _mobileMenuAndSearch = {
	mobileMenuBhe: function () {
	    $('.custom-navbar-toggler').on('click', function() {
	    	if($('.cerca-collapse').hasClass('show')){
	    		$('.search-link').click();
	    	}
	    });
	    $('.search-link').on('click', function() {
	    	if($('.navbar-collapsable').hasClass('expanded')){
	    		$('.navbar-collapsable .overlay').click();
	    	}
	    });
	},
	init: function () {
	    if($('.custom-navbar-toggler').length > 0){
	       	this.mobileMenuBhe();
	    }
	}
};

var _searchMobileCollapse = {
    collapseBhe: function () {
        $(".cerca-collapse").on("hide.bs.collapse", function () {
            $(".icon-change.search-icon").removeClass('d-none');
            $(".icon-change.close-icon").addClass('d-none');
        });
        $(".cerca-collapse").on("show.bs.collapse", function () {
        	$(".icon-change.search-icon").addClass('d-none');
            $(".icon-change.close-icon").removeClass('d-none');
        });
    },
    init: function () {
        if($('.cerca-collapse').length > 0){
            this.collapseBhe();
        }
    }
};

var $wrapper_results = $('.more-results');

var _moreBehaviors = function ($el) {
	
	var total = $el.attr('data-results-for-page');
	
	$el.find('.more').on('click', function (e) {
        e.preventDefault();
        var $itemHidden = $el.find('.d-none');
        $itemHidden.slice(0,total).fadeIn(300, function () {
            $itemHidden.slice(0,total).removeClass('d-none');
            if ( $el.find('.d-none').length === 0 ) {
                $el.find('.more').hide();
            }
        });
    });


};

var _popoverIcon = {
    popoverBehaviors: function () {
    	$('.icon-popover[data-toggle="popover"]').popover();
    },
    dispose: function (element) {
    	element.popover('dispose');
    },
    init: function () {
    	if($('.icon-popover').length > 0){
    		this.popoverBehaviors();
        }
    }
};

var _searchGenerico = {
	actions: function () {	
	    $(".search_generico_text").keypress(function(e) {
	    	if(e.which == 13) {
	    		$("#search_generico_form").submit();
	    	}
	    });
	},
	init: function () {
	    if($('.search_generico_text').length > 0) {
	    	this.actions();
	    }
	}
};

var _anchorLink = {
	anchor: function () {	
		$(document).on('click', '.anchor-link', function (event) {	
			event.preventDefault();
			$("html, body").animate({ scrollTop: $($(this).attr("href")).offset().top }, 500);
		});
	},
	init: function () {
	    this.anchor();
	}
};

/*
 * Per aprire l'Alert porre la classe 'open-alert' all'elemento del DOM interessato e aggiungere allo stesso 
 * l'attributo 'th:data-message' con valore il messaggio definito nelle properties
 * l'attributo 'th:data-icon' con valore il nome dell'icona
 * l'attributo 'th:data-color' con valore 'icon-success' oppure 'icon-warning' oppure 'icon-danger' per definire il colore dell'icona
 */
var _openAlert = {
	openAlert: function () {
	    $('.open-alert').on('click', function() {
	    	_openAlert.show($(this).data('message'), $(this).data('icon'), $(this).data('color'));
	    });
	},
	show: function (message, icon, color) {
	    	
	    var url = window.__CONTEXT_PATH__ + '/api/openAlert';
		
	    $.ajax({
			dataType: "html",
			crossDomain: true,
            url: url,
            data: 'message=' + encodeURIComponent(message) + '&icon=' + icon + '&color=' + color,
			type: "POST",
			cache: false,
			processData: true,
			scriptCharset: "utf-8",
			contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
			success: function(fragment) {
				$("#modalAlert").replaceWith(fragment);
				$("#modalAlert").modal('show');
			},
			error: function(xhr) {
				console.log(xhr.responseText);
			}
		});

			
	},
	init: function () {
	    if($('.open-alert').length > 0){
	       	this.openAlert();
	    }
	}
};

var _sharePopup = {
	share: function () {	
		$('.share-popup').on('click', function(e) {
			e.preventDefault();
	        window.open($(this).attr("href"), "popupWindow", "width=600,height=600,scrollbars=yes");
	    });
	},
	init: function () {
		if($('.share-popup').length > 0){
			this.share();
		}	
	}
};

_mobileMenuAndSearch.init();

$(function() {
    
    _get_date_time.init();
    _calcNavOffsetTop.init();
    _popoverLogin.init();
    _openFooterModal.init();
    _openCommonModal.init();
    _searchMobileCollapse.init();
    _popoverIcon.init();
    _searchGenerico.init();
    _openAlert.init();
    _anchorLink.init();
    _changeProfile.init();
    _sharePopup.init();
	_login.init();
	_logout.init();
    
    $wrapper_results.each(function () {
        var $this = $(this);
        if($('.more-results').length > 0) {
        	_moreBehaviors($this);
        }
    });

});