var _autoSubmit = {
    submitBehaviors: function () {
    	$('#advanced-search').submit();
    },
    init: function () {
    	$('#advanced-search .form-control').each(function() {
    		if($(this).val() !== ''){
    			_autoSubmit.submitBehaviors();
    			return false;
    		} 
    	});
    }
};

var _setMesView = function(idNotification, isView) {
	$('.loader').addClass('show');
	$.ajax({
		type: "POST",
		url: window.__CONTEXT_PATH__ + '/la-mia-area/messaggi/updateCommunicationView/' + idNotification + '?isView=' + isView,
		success: function() {
			$('#dtMessaggi').DataTable().page($('#dtMessaggi').DataTable().page()).draw('page');
			$('.loader').removeClass('show');
		},
		error: function(xhr) {
			//console.log(xhr.responseText);
			_openAlert.show(window.__ERROR_MSG__,window.__ERROR_ICON__,window.__ERROR_COLOR_ICON__);
		}
	});
};

var table = $('#dtMessaggi').DataTable();

$('#dtMessaggi tbody').on('click','button.dt-btn-action', function(){
	var data = table.row( $(this).parents('tr') ).data();
	
	$.each( data, function( key, value ) {
		if(value){
			$('#modalMessage .message-table .data-' + key).html(value);
			$('#modalMessage .message-table .data-' + key).closest('tr').removeClass('d-none');
		}
	});
	
	if (!data.read) {
		data.read = !data.read;
		_setMesView(data.npId, true);
	}
});

$('#dtMessaggi tbody').on('click', '.read-unread-icon', function() {
	var data = table.row( $(this).parents('tr') ).data();
	
	if(data.read) {
		data.read = !data.read;
		_setMesView(data.npId, false);
	} else {
		data.read = !data.read;
		_setMesView(data.npId, true);
	}
	
	_popoverIcon.dispose($(this));
});

$('#simple-search').on( 'submit', function (e) {
	e.preventDefault();
	$('#advanced-search .form-control').each(function() {
		if($(this).val() !== ''){
			$('#advanced-search .form-control#comunicazione').val($('#simple-search .search-field').val());
			$('#advanced-search').submit();
			return false;
		} else {
			$('#dtMessaggi').DataTable().search($('#simple-search .search-field').val()).draw();
		}
	});
	
	if($('.dropdown-ricerca').hasClass('show')){
		$('.btn-ricerca-avanzata').click();
	}
});

$('#advanced-search').on('submit', function(e) {
	e.preventDefault();
	
	if($(this).find('.from-date').val() || $(this).find('.to-date').val()) {
		$(this).find('#filter_data_min_max').val($(this).find('.from-date').val()+'_'+$(this).find('.to-date').val());
	} else {
		$(this).find('#filter_data_min_max').val('');
	}

	var table = $('#dtMessaggi').DataTable();
	$('.aria-filters .chip').not('.d-none').remove();
	$(this).find('.form-control').each(function() {
		var value = $(this).hasClass('toggle-field') ? checkboxValue($(this)) : $(this).val();
		table.column( $(this).data('column') ).search( value );
		if(value || value === 0) {
			if($(this).attr('id') != 'filter_data_min_max') {
				var filter = $('.aria-filters .chip.d-none').clone(true);
				if($(this).hasClass('filter-label')) {
					filter.find('.chip-label').html($(this).data('name') + ': ' + $(this).find('option:selected').text());
				} else if($(this).hasClass('toggle-field')) {
					filter.find('.chip-label').html($(this).data('chip-label'));
				} else  {
					filter.find('.chip-label').html($(this).data('name') + ': ' + $(this).val());
				}
				filter.find('.delete-filter').attr('data-id', $(this).attr('id'));
				filter.removeClass('d-none');
				$('.aria-filters').append(filter);
			}
		}
	});
	table.draw();
	if($('.dropdown-ricerca').hasClass('show')) {
		$('.btn-ricerca-avanzata').click();
	}
});

var checkboxValue = function(element) {
	return element.is(':checked') ? 0 : '';
};

$('.aria-filters .chip .delete-filter').on('click', function(e){
	e.preventDefault();
	$('#advanced-search .form-control#'+$(this).data('id')).val('');
	$('#advanced-search .form-control#'+$(this).data('id')).click();
	$('#advanced-search-dropdown input.form-control#'+$(this).data('id')).val('');
	$('#advanced-search-dropdown select.form-control#'+$(this).data('id')).selectpicker('val', '');
	$('#advanced-search-dropdown select.form-control#'+$(this).data('id')).selectpicker('refresh');
	$('#advanced-search').submit();
	$(this).closest('.chip').remove();
});

$('#advanced-search-dropdown .btn-reset-filters').on('click', function(e){
	e.preventDefault();
	if($('#simple-search .search-field').val()){
		$('#simple-search .search-field').val('');
		$('#dtMessaggi').DataTable().search('').draw();
	}	
	$('.aria-filters .chip').not('.d-none').remove();
	$('#advanced-search-dropdown input.form-control').val('');
	$('#advanced-search #filter_data_min_max').val('');
	$('#advanced-search-dropdown select.form-control').selectpicker('val', '');
	$('#advanced-search-dropdown select.form-control').selectpicker('refresh');
	if($('.toggle-field').is(':checked')){
		$('.toggles .lever').click();
	}
	$('#advanced-search').submit();
	if($('.dropdown-ricerca').hasClass('show')){
		$('.btn-ricerca-avanzata').click();
	}
});

$(function() {
    
    $('#dtMessaggi').dataTable().fnSettings().aoRowCallback.push({
    	"fn": function (row, data) {
    		
    		var stripdata = data.npCommunication.replace(/<[^>]+>/g, '');
    		
    		if(stripdata.length > 120) {
    			stripdata = stripdata.substring(0, 120) + ' ...';
    		}
    		
    		$(row).find('td[data-title="Comunicazione"]').html(stripdata);
    		
    		if(data.read) {
    			$(row).find('.read-unread-icon > use').attr('href', $(this).closest('table').data('unread-icon'));
    			$(row).find('.read-unread-icon').attr('data-content', $(this).closest('table').data('unread-text-popover'));
			} else {
				$(row).addClass("unread");
				$(row).find('.read-unread-icon > use').attr('href', $(this).closest('table').data('read-icon'));
				$(row).find('.read-unread-icon').attr('data-content', $(this).closest('table').data('read-text-popover'));
			}
		},
		"sName": "createdRow"
    });
    
    $('#dtMessaggi').dataTable().fnSettings().aoDrawCallback.push({
    	"fn": function () {
    		_popoverIcon.init();
		},
		"sName": "drawCallback"
    });
        
    _autoSubmit.init();
    
});