
//begin datatables
var dataTablesInit = function ($el) {

    var columns = [];
    $el.find('thead tr th').each(function () {
        columns.push({'data':$(this).data('column'),'title':$(this).html()});
    });
    
    $el.DataTable({
        "ajax": {
        	"url": $el.data('url'),
        	"type": ($el.data('type') ? $el.data('type') : "GET")
        }, 
        "columns": columns,
        "sScrollX": "100%",
        "deferRender": true,
        "processing": true,
        "responsive": false,
        "language": {
        	"url": $el.data('language-url'),
        	"paginate": {
                "next": '<svg class="icon"><use xlink:href="'+$el.data('next')+'"></use></svg>',
                "previous": '<svg class="icon"><use xlink:href="'+$el.data('prev')+'"></use></svg>'
            }
        },
        "initComplete": function() {
        	/*
            $el.find('tbody').on('click', 'tr', function () {
                var data = table.row(this).data();
                console.log(data.id);
            });
            */
        },
        'createdRow': function(row) {
            $.each(columns, function(index, value) {
                $(row).find('td').eq(index).attr('data-title', value.title);
            });
        },
        "preDrawCallback": function() {
        	$('.loader').addClass('show');
        },
        "drawCallback": function(oSettings) {
        	$('.loader').removeClass('show');
        	$(window).trigger('resize');
        	if (!oSettings.fnRecordsDisplay()) {
                $(oSettings.nTableWrapper).find('.dataTables_paginate').hide();
                $(oSettings.nTableWrapper).find('.dataTables_info').hide();
                $(oSettings.nTableWrapper).find('.dataTables_length').hide();
            } else {
            	$(oSettings.nTableWrapper).find('.dataTables_paginate').show();
            	$(oSettings.nTableWrapper).find('.dataTables_info').show();
                $(oSettings.nTableWrapper).find('.dataTables_length').show();
                if (oSettings._iDisplayLength >= oSettings.fnRecordsDisplay()) {
                    $(oSettings.nTableWrapper).find('.dataTables_paginate').hide();
                } else {
                	$(oSettings.nTableWrapper).find('.dataTables_paginate').show();
                }
            }
        }
    });

};
//end datatables


if($($('.data-table-ajax')).length > 0) {
    $('.data-table-ajax').each(function () {
        var $this = $(this);
        dataTablesInit($this);
    });
}
    
