var initDatePickSimple = function ($el) {

    var inputFormat = $el.data('input-format');
    var outputFormat = $el.data('output-format');
    if (inputFormat === undefined) { inputFormat = ['dd/MM/yyyy']; }
    if (outputFormat === undefined) { outputFormat = 'dd/MM/yyyy'; }

    $el.datepicker({
        inputFormat: inputFormat,
        outputFormat: outputFormat
    });
    
    if($el.data('disabled') == 'disabled'){
    	$el.datepicker('disable');
    }
    
    $el.inputmask({placeholder: 'gg/mm/aaaa', showMaskOnHover: false, showMaskOnFocus: false, "clearIncomplete": true});
    
};

var initDatePickRange = function ($el) {
	
	var inputFormat = $el.data('input-format');
    var outputFormat = $el.data('output-format');
    if (inputFormat === undefined) { inputFormat = ['dd/MM/yyyy']; }
    if (outputFormat === undefined) { outputFormat = 'dd/MM/yyyy'; }

    $el.closest('.form-group').find('.from-date').datepicker({
    	gainFocusOnConstruction: false,
    	inputFormat: inputFormat,
        outputFormat: outputFormat,
    	next: '.to-date'
    });
    
    $el.closest('.form-group').find('.to-date').datepicker({
    	gainFocusOnConstruction: false,
    	inputFormat: inputFormat,
        outputFormat: outputFormat,
    	previous: '.from-date'
    });
    
    if($el.data('disabled') == 'disabled'){
    	$el.datepicker('disable');
    }
    
    $el.inputmask({placeholder: 'gg/mm/aaaa', showMaskOnHover: false, showMaskOnFocus: false, "clearIncomplete": true});
    
};

$(function() {
    
    $('.datepicker-date-simple').each(function () {
        var $this = $(this);
        if($('.datepicker-date-simple').length > 0) {
            initDatePickSimple($this);
        }
    });

    $('.datepicker-date-range').each(function () {
        var $this = $(this);
        if($('.datepicker-date-range').length > 0) {
            initDatePickRange($this);
        }
    });
    
});