var _deleteDelega = {
	deleteDelegaBtnBhe: function () {
		var that = this;
	    $('.delete-delega').on('click', function(e) {
	    	e.preventDefault();
	    	that.deleteDelega($(this).data('id'));
	    });
	},
	deleteCreatoreGruppoBtnBhe: function (){
		var that = this;
	    $('.le-mie-deleghe').on('click', '.elimina-creatore', function(e) {
	    	e.preventDefault();
	    	
	    	that.deleteCreatore();
	    });
	},
	deleteDelega : function (idDelega) {
		$.ajax({
			type : "POST",
			url : window.__CONTEXT_PATH__ + '/la-mia-area/i-miei-gruppi/elimina-delega',
			data : {'idDelega' : idDelega, "uuidGruppo" : idGruppo},
			beforeSend: function() {
		    	$('.loader').addClass('show'); 
		    },
			success : function(data) {
				if (data.redirect) {
					window.location.href = data.redirect;
				}
			},
			error : function(xhr) {
				//console.log(xhr.responseText);
				_openAlert.show(window.__ERROR_MSG__,window.__ERROR_ICON__,window.__ERROR_COLOR_ICON__);
			}
		}).done(function() {
			$('.loader').removeClass('show');
		});
	},
	deleteCreatore : function () {
		$.ajax({
			type : "POST",
			url : window.__CONTEXT_PATH__ + '/la-mia-area/i-miei-gruppi/elimina-delega-creatore',
			data : {"uuidGruppo" : idGruppo},
			beforeSend: function() {
		    	$('.loader').addClass('show'); 
		    },
			success : function(data) {
				if (data.redirect) {
					window.location.href = data.redirect;
				}
			},
			error : function(xhr) {
				//console.log(xhr.responseText);
				_openAlert.show(window.__ERROR_MSG__,window.__ERROR_ICON__,window.__ERROR_COLOR_ICON__);
			}
		}).done(function() {
			$('.loader').removeClass('show');
		});
	},
	init: function () {
	    if($('.delete-delega').length > 0){
	       	this.deleteDelegaBtnBhe();
	    }
	    this.deleteCreatoreGruppoBtnBhe();
	}
};

var _searchDeleghe = {
	filter : function(){
		var that = this;
		$('.le-mie-deleghe').on('keypress', '.ricerca-semplice' , function(e) {
    		if(e.which == 13) {
    			var search = $(".ricerca-semplice").val();
    			that.search(search);
    		}
    	});
		$('.le-mie-deleghe').on('click', '.btn-search' , function(e) {
    		e.preventDefault();
			var search = $(".ricerca-semplice").val();
			that.search(search);
    	});
	},
	search: function (search){
		var url = searchDelega;
		if (search){
			url += '/' + search; 
		}
		$.ajax({
		    type: "GET",
		    url: url, 
		    beforeSend: function() {
		    	$('.loader').addClass('show'); 
		    },
		    success: function(data){
		    	if(data.indexOf('error-page') !== -1){
					_openAlert.show(window.__ERROR_MSG__,window.__ERROR_ICON__,window.__ERROR_COLOR_ICON__);
				} else {
					$(".lista-deleghe").replaceWith(data);
				}
		    },
			error : function(xhr) {
				//console.log(xhr.responseText);
				_openAlert.show(window.__ERROR_MSG__,window.__ERROR_ICON__,window.__ERROR_COLOR_ICON__);
			}
		}).done(function() {
			$('.loader').removeClass('show');
		});
	},
	init: function (){
		if($('.ricerca-semplice').length > 0){
			this.filter();
		}	
	}
};

var _modificaTipoDelega = {
	modificaTipoDelegaBtnBhe: function () {
		var that = this;
	    $('.modifica-tipo-delega').on('click', function(e) {
	    	e.preventDefault();
	    	that.modificaTipoDelega($(this).data('id'));
	    });
	},
	modificaTipoDelega: function (idDelega) {
		$.ajax({
			type : "POST",
			url : window.__CONTEXT_PATH__ + '/la-mia-area/i-miei-gruppi/modifica-tipo-delega',
			data : {'idDelega' : idDelega, "uuidGruppo" : idGruppo},
			beforeSend: function() {
		    	$('.loader').addClass('show'); 
		    },
			success : function(data) {
				if (data.redirect) {
					window.location.href = data.redirect;
				}
			},
			error : function(xhr) {
				//console.log(xhr.responseText);
				_openAlert.show(window.__ERROR_MSG__,window.__ERROR_ICON__,window.__ERROR_COLOR_ICON__);
			}
		}).done(function() {
			$('.loader').removeClass('show');
		});
	},
	init: function() {
		this.modificaTipoDelegaBtnBhe();
	}
};

$(function() {
	_deleteDelega.init();
	_searchDeleghe.init();
	_modificaTipoDelega.init();
});