var _deleteGroup = {
	deleteGroupBtnBhe: function () {
		var that = this;
	    $('.delete-group').on('click', function(e) {
	    	e.preventDefault();
	    	that.deleteGroup($(this).data('id'));
	    });
	},
	deleteGroup : function (uuidGruppo) {
		$.ajax({
			type : "POST",
			url : window.__CONTEXT_PATH__ + '/dati-utente/i-miei-profili/elimina-gruppo',
			data : {'uuidGruppo' : uuidGruppo},
			success : function(data) {
				if (data.redirect) {
					window.location.href = data.redirect;
				}
			},
			error : function(xhr) {
				//console.log(xhr.responseText);
				_openAlert.show(window.__ERROR_MSG__,window.__ERROR_ICON__,window.__ERROR_COLOR_ICON__);
			}
		});
	},
	init: function () {
	    if($('.delete-group').length > 0){
	       	this.deleteGroupBtnBhe();
	    }
	}
};

var _searchGroups = {
	filter : function(){
		var that = this;
		$('.i-miei-gruppi').on('keypress', '.ricerca-semplice' , function(e) {
    		if(e.which == 13) {
    			var search = $(".ricerca-semplice").val();
    			that.search(search);
    		}
    	});
		$('.i-miei-gruppi').on('click', '.btn-search' , function(e) {
    		e.preventDefault();
			var search = $(".ricerca-semplice").val();
			that.search(search);
    	});
	},
	search: function (search){
		// ricerca tramite refresh
		var url = urlRicercaGruppi;
		if (search){
			url += '/' + search; 
		}
		$.ajax({
		    type: "GET",
		    url: url, 
		    beforeSend: function() {
		    	$('.loader').addClass('show');
		    },
		    success: function(data){
		    	if(data.indexOf('error-page') !== -1){
    				_openAlert.show(window.__ERROR_MSG__,window.__ERROR_ICON__,window.__ERROR_COLOR_ICON__);
    			} else {
    				$(".lista-gruppi").replaceWith(data);
    			}
		    },
		    error: function(){
		    	_openAlert.show(window.__ERROR_MSG__,window.__ERROR_ICON__,window.__ERROR_COLOR_ICON__);
		    }
		}).done(function() {
			$('.loader').removeClass('show');
		});
	},
	init: function (){
		if($('.ricerca-semplice').length > 0){
			this.filter();
		}	
	}
};

var _becomeAdmin = {
	becomeAdminBtnBhe: function(){
		var that = this;
	    $('.i-miei-gruppi').on('click', '.become-admin', function(e) {
	    	e.preventDefault();
	    	that.becomeAdmin();
	    });
	},
	becomeAdmin: function (){
		$.ajax({
			type : "POST",
			url : window.__CONTEXT_PATH__ + '/la-mia-area/i-miei-gruppi/become-admin',
			success : function(data) {
				if (data.errors){
					setTimeout(function (){
						_openCommonModal.show({ content: 'diventa-amministratore-error-modal' });
						}, 250 );
				}
				if (data.redirect) {
					window.location.href = data.redirect;
				}
			},
			error : function(xhr) {
				//console.log(xhr.responseText);
				_openAlert.show(window.__ERROR_MSG__,window.__ERROR_ICON__,window.__ERROR_COLOR_ICON__);
			}
		});
	},
	init: function (){
		this.becomeAdminBtnBhe();
	}
};

$(function() {
	_deleteGroup.init();
	_searchGroups.init();
	_becomeAdmin.init();
});