var _switchCode = {
    codeBehavior: function () {
    	$('input[name="codFiscaleEstero"]').on('click', function(){
    		var label;
    		if($(this).val() == 'false'){
    			label = $('input[name="codice_fiscale_label"]').val();
    			$('input[name="codiceFiscale"]').attr('placeholder',label);
    			$('label[for="codiceFiscale"]').html(label);
    		} else {
    			label = $('input[name="codice_identificativo_label"]').val();
    			$('input[name="codiceFiscale"]').attr('placeholder',label);
    			$('label[for="codiceFiscale"]').html($('input[name="codice_identificativo_label"]').data('label'));
    		}
    	});
    },
    init: function () {
    	if($('input[name="codFiscaleEstero"]').length > 0){
    		this.codeBehavior();
        }
    }
};

var _submitForm = {
	ajaxForm: function () {
    	$('#formProfilo').on('submit', function(e){
    		e.preventDefault();
    		
    		$('.loader').addClass('show');
    		
    		if($('#codiceFiscale').val() !== '' && $('#natureGiuridicheProposte').val() !== ''){
    			$.ajax({
    				dataType: "json",
    				crossDomain: true,
    			    url: urlCreaProfilo,
    			    data: 'codiceFiscale='+$('#codiceFiscale').val()+'&codFiscaleEstero='+$('input[name="codFiscaleEstero"]').val()+'&codiceNaturaGiuridica='+$('#natureGiuridicheProposte').val(),
    				type: "POST",
    				cache: false,
    				processData: true,
    				contentType: 'application/x-www-form-urlencoded',
    				success: function(data) {
    					//console.log(data.errors[0]);
    					if (data.redirect !== undefined){
							window.location.href = data.redirect;
						} else if(data.profiloQualificaNonValido === undefined || data.profiloQualificaNonValido !== true){
							window.location.href = window.__CONTEXT_PATH__+'/dati-utente/i-miei-profili/dettaglio-profilo';
						} else if(data.errors[0]){
    						$('.wrapper-alert .alert .content').html(data.errors[0]);
        					$('.wrapper-alert').removeClass('d-none');
    					}
    					$('.loader').removeClass('show');
    				},
    				error: function(xhr) {
    					//console.log("error",xhr.responseText);
    					_openAlert.show(window.__ERROR_MSG__,window.__ERROR_ICON__,window.__ERROR_COLOR_ICON__);
    				}
    			});
    		} else if($('#codiceFiscale').val() !== ''){
    			$.ajax({
    				dataType: "json",
    				crossDomain: true,
    			    url: urlNatureGiuridicheProposte,
    			    data: 'codiceFiscale='+$('#codiceFiscale').val()+'&codFiscaleEstero='+$('input[name="codFiscaleEstero"]').val(),
    				type: "GET",
    				cache: false,
    				processData: true,
    				contentType: 'application/json',
    				success: function(data) {
    					var select = [];
    					$.each( data.natureGiuridicheProposte, function( key, value ) {
    		    			select.push( {'text':value,'value':key} );
    		    		});
    					$('.bootstrap-select-wrapper.natureGiuridicheProposte').setOptionsToSelect(select);
    					if(select.length == 1){
    						$('#natureGiuridicheProposte').val(select[0].value);
    						$('#natureGiuridicheProposte').selectpicker('refresh');
    					}
    					$('.bootstrap-select-wrapper.natureGiuridicheProposte').removeClass('d-none');
    					$('.callout.natureGiuridicheProposte').removeClass('d-none');
    					$('.loader').removeClass('show');
    				},
    				error: function(xhr) {
    					//console.log("error",xhr.responseText);
    					_openAlert.show(window.__ERROR_MSG__,window.__ERROR_ICON__,window.__ERROR_COLOR_ICON__);
    				}
    			});
    		}
    	});
    	$('.reset-button').on('click', function(){
    		$('#natureGiuridicheProposte').selectpicker('val', '');
    		$('#natureGiuridicheProposte').selectpicker('refresh');
    		$('.bootstrap-select-wrapper.natureGiuridicheProposte').addClass('d-none');
			$('.callout.natureGiuridicheProposte').addClass('d-none');
			$('.wrapper-alert').addClass('d-none');
    	});
    },
    init: function () {
    	if($('#formProfilo').length > 0){
    		this.ajaxForm();
        }
    }
};

$(function() {
	
	_switchCode.init();
	_submitForm.init();

});