var _preferiti = {
	createReqObj : function(page, maxPage) {
		var req = { 
			titolo : '',
			pageNum : 0,
			maxPageNum : 0,
			targetStr : '',
			target : [],
			ricercaAvanzata : false,
			bandiChiusi: false
		};
			
		if(page) {
			req.pageNum = page;
		}
			
		if(maxPage) {
			req.maxPageNum = maxPage;
		}
			
		return req;	
	},
		
	initPaginatore : function() {
		var those = this;
			
		$('.preferiti').on('click', '.page-num', function(e) {
			e.preventDefault();
			var that = $(this);
			var page = that.attr('data-page-num');
			var maxPage = that.attr('data-max-page-num');
				
			those.ajaxCall(those.getUrl(), those.createReqObj(page, maxPage), function(data) {
				if(data.indexOf('error-page') !== -1){
    				_openAlert.show(window.__ERROR_MSG__,window.__ERROR_ICON__,window.__ERROR_COLOR_ICON__);
    			} else {
    				$(".catalogo_bandi_preferiti").replaceWith(data);
    			}
			});
		});
			
		$('.preferiti').on('click', '.page-up', function(e) {
			e.preventDefault();
			var that = $(".page-link[aria-current='page']");
			var page =  parseInt(that.attr('data-page-num')) + 1;
			var maxPage = that.attr('data-max-page-num');
				
			those.ajaxCall(those.getUrl(), those.createReqObj(page, maxPage), function(data) {
				if(data.indexOf('error-page') !== -1){
    				_openAlert.show(window.__ERROR_MSG__,window.__ERROR_ICON__,window.__ERROR_COLOR_ICON__);
    			} else {
    				$(".catalogo_bandi_preferiti").replaceWith(data);
    			}
			});
		});
			
		$('.preferiti').on('click', '.page-down', function(e) {
			e.preventDefault();
			var that = $(".page-link[aria-current='page']");
			var page =  parseInt(that.attr('data-page-num')) - 1;
			var maxPage = that.attr('data-max-page-num');
				
			those.ajaxCall(those.getUrl(), those.createReqObj(page, maxPage), function(data) {
				if(data.indexOf('error-page') !== -1){
    				_openAlert.show(window.__ERROR_MSG__,window.__ERROR_ICON__,window.__ERROR_COLOR_ICON__);
    			} else {
    				$(".catalogo_bandi_preferiti").replaceWith(data);
    			}
			});
		});
	},
	
	getUrl : function() {
		return window.__CONTEXT_PATH__ + '/api/getPreferitiPaginati';
	},
	    
	ajaxCall : function(url, data, onSuccess) {
	    if(url && data && onSuccess) {
	    	$.ajax({
	    		type: "POST",
				url: url,
				data: data,
				beforeSend: function() {
				    $('.loader').addClass('show');
				},
				success: onSuccess
			}).done(function() {
				$('.loader').removeClass('show');
				_popoverIcon.init(); 
			}).fail(function() {
				_openAlert.show(window.__ERROR_MSG__,window.__ERROR_ICON__,window.__ERROR_COLOR_ICON__);
			});	    		
	    }
	},
	
	init: function() {
	    this.initPaginatore();
	}
};

$(function() {
    _preferiti.init();
});	