//begin slider
var initCarousel = function ($el) {

    var items = $el.data('items');
    var loop = $el.data('loop');
    var margin = $el.data('margin');
    var autoplay = $el.data('autoplay');
    var autoplayTimeout = $el.data('autoplay-timeout');
    var autoplayHoverPause = $el.data('autoplay-hover-pause');
    var dots = $el.data('dots');

    if (items === undefined) { items = 1; }
    if (loop === undefined) { loop = true; }
    if (margin === undefined) { margin = 10; }
    if (autoplay === undefined) { autoplay = true; }
    if (autoplayTimeout === undefined) { autoplayTimeout = 5000; }
    if (autoplayHoverPause === undefined) { autoplayHoverPause = true; }
    if (dots === undefined) { dots = true; }

    var owl = $el.find('.owl-carousel').owlCarousel({
        items: items,
        loop: loop,
        margin: margin,
        autoplay: autoplay,
        autoplayTimeout: autoplayTimeout,
        autoplayHoverPause: autoplayHoverPause,
        dots: dots
    });
    $el.find('.play').on('click', function () {
        owl.trigger('play.owl.autoplay', [5000]);
    });
    $el.find('.stop').on('click', function () {
        owl.trigger('stop.owl.autoplay');
    });

    $el.find('.customNextBtn').click(function () {
        owl.trigger('next.owl.carousel');
    });
    // Go to the previous item
    $el.find('.customPrevBtn').click(function () {
        // With optional speed parameter
        // Parameters has to be in square bracket '[]'
        owl.trigger('prev.owl.carousel', [300]);
    });
    var btn = $el.find('.play,.stop').click(function () { // bind click handler to both button
        $(this).hide(); // hide the clicked button
        btn.not(this).show(); // show the another button which is hidden
    });

};
//end slider

$(function() {
	
    $('.it-carousel-wrapper').each(function () {
        var $this = $(this);
        if($('.owl-carousel').length > 0) {
            initCarousel($this);
        }
    });

});